/******************************************************************************
*                                                  
*  (c) copyright Freescale Semiconductor 2010
*  ALL RIGHTS RESERVED
*
*  File Name:   ButtonsHandler.hc
*                                                                          
*  Description: C source for Buttons Handling on Activity Monitor
*                                                                                     
*  Assembler:   Codewarrior for HC(S)08 V6.1
*                                            
*  Version:     1.0                                                         
*                                                                                                                                                         
*  Author:      Santiago Lopez [SL](SSE Americas)
*              
*                                                                                     
*  Location:    Guadalajara,Mexico                                              
*                                                                                                                  
*                                                  
* UPDATED HISTORY:
*
* REV   YYYY.MM.DD  AUTHOR   DESCRIPTION OF CHANGE
* ---   ----------  ------   --------------------- 
* 1.0   2010.11.22    SL        Initial version
* 
******************************************************************************/                                                                        
/* Freescale  is  not  obligated  to  provide  any  support, upgrades or new */
/* releases  of  the Software. Freescale may make changes to the Software at */
/* any time, without any obligation to notify or provide updated versions of */
/* the  Software  to you. Freescale expressly disclaims any warranty for the */
/* Software.  The  Software is provided as is, without warranty of any kind, */
/* either  express  or  implied,  including, without limitation, the implied */
/* warranties  of  merchantability,  fitness  for  a  particular purpose, or */
/* non-infringement.  You  assume  the entire risk arising out of the use or */
/* performance of the Software, or any systems you design using the software */
/* (if  any).  Nothing  may  be construed as a warranty or representation by */
/* Freescale  that  the  Software  or  any derivative work developed with or */
/* incorporating  the  Software  will  be  free  from  infringement  of  the */
/* intellectual property rights of third parties. In no event will Freescale */
/* be  liable,  whether in contract, tort, or otherwise, for any incidental, */
/* special,  indirect, consequential or punitive damages, including, but not */
/* limited  to,  damages  for  any loss of use, loss of time, inconvenience, */
/* commercial loss, or lost profits, savings, or revenues to the full extent */
/* such  may be disclaimed by law. The Software is not fault tolerant and is */
/* not  designed,  manufactured  or  intended by Freescale for incorporation */
/* into  products intended for use or resale in on-line control equipment in */
/* hazardous, dangerous to life or potentially life-threatening environments */
/* requiring  fail-safe  performance,  such  as  in the operation of nuclear */
/* facilities,  aircraft  navigation  or  communication systems, air traffic */
/* control,  direct  life  support machines or weapons systems, in which the */
/* failure  of  products  could  lead  directly to death, personal injury or */
/* severe  physical  or  environmental  damage  (High  Risk Activities). You */
/* specifically  represent and warrant that you will not use the Software or */
/* any  derivative  work of the Software for High Risk Activities.           */
/* Freescale  and the Freescale logos are registered trademarks of Freescale */
/* Semiconductor Inc.                                                        */ 
/*****************************************************************************/


/*****************************************************************************/
/*                                Includes
/*****************************************************************************/

 #include "ButtonsHandler.h"

/*****************************************************************************/
/*                                 Globals
/*****************************************************************************/

 extern UINT8 gu8ButtonStatus = BUTTON_IDDLE;

/*****************************************************************************/
/*                           Functions Definition
/*****************************************************************************/
 #if 0
 void vfnButtons_Init (void)
 {
  #ifdef PUSH_BUTTONS_ENABLED
  /*
  PTADD &= 0xFD;        //PTA1 as input
  PTAPE |= 0x02;        //PTA1 pull-up enabled
  PTBDD &= 0xBF;        //PTB6 as input
  PTBPE |= 0x40;        //PTB6 pull-up enabled
  KBI1PE = KBI1PE_KBI1PE0_MASK | KBI1PE_KBI1PE3_MASK; //KBI1P0 and KBI1P1 as interrupts
  KBI1SC = 0x06;        //KBI1 Enabled edges only
  
  PTEDD &= 0xF1;        //PTE1,2 and 3 as input
  PTEPE |= 0x0E;        //PTE1,2 and 3 pull-up enabled
  PTFDD &= 0xDF;        //PTF5 as input
  PTFPE |= 0x20;        //PTF5 pull-up enabled
  KBI2PE = KBI2PE_KBI2PE4_MASK | KBI2PE_KBI2PE5_MASK | KBI2PE_KBI2PE6_MASK | KBI2PE_KBI2PE7_MASK;
  KBI2SC = 0x06;        //KBI2 Enabled edges only
  */
  #endif
 }
 
 interrupt VectorNumber_Vkbi1 void vfnKBI1_ISR(void)
 {
  if(PTAD_PTAD1==0)
  gu8ButtonStatus = BUTTON_UP;
  
  if(PTBD_PTBD6==0)
  gu8ButtonStatus = BUTTON_DOWN;
  
  //delay(5000);//Avoid Bouncing
  KBI1SC_KB1ACK = 1;
 }
 
  interrupt VectorNumber_Vkbi2 void vfnKBI2_ISR(void)
 {
  if(PTED_PTED1==0)
  gu8ButtonStatus = BUTTON_LEFT;
  
  if(PTED_PTED2==0)
  gu8ButtonStatus = BUTTON_RIGHT;
  
  if(PTED_PTED3==0)
  gu8ButtonStatus = BUTTON_SELECT;
  
  if(PTFD_PTFD5==0)
  gu8ButtonStatus = BUTTON_EXIT;
  
  //delay(5000);//Avoid Bouncing
  KBI2SC_KB2ACK = 1;
 }  
 
 #endif
 
